#include "RigidBody.h"

#include <d3dx9.h>


//RXgN^
//yFȂz
CRigidBody::CRigidBody(void):
_pBody(NULL), _inertia(0.0f, 0.0f, 0.0f)
{
	return;
}



//fXgN^
//yF--z
CRigidBody::~CRigidBody(void)
{
	//Ă΂ĂȂ߁AfXgN^ŔÔߍ폜Ăł
	DeleteRigidBody( );


	return;
}



//傫1̊{VFCṽCX^X𐶐
//y߂lF{VFCṽCX^XzyF{VFCvz
btCollisionShape* CRigidBody::CreateNormalizeShape(BASIC_SHAPE shape)
{
	btCollisionShape *pRet ;


	//{VFCv̌`𒲂ׁACX^X𐶐
	switch( shape ){
		//
		case BASIC_SHAPE_BOX:
			pRet = new btBoxShape(btVector3(1.0f, 1.0f, 1.0f));
			break;

		//
		case BASIC_SHAPE_SPHERE:
			pRet = new btSphereShape(btScalar(1.0f));
			break;

		//YɐLтJvZ
		case BASIC_SHAPE_CAPSULE_Y:
			pRet = new btCapsuleShape(btCapsuleShape(1.0f, 1.0f));
			break;

		//XɐLтJvZ		
		case BASIC_SHAPE_CAPSULE_X:
			pRet = new btCapsuleShapeX(btCapsuleShapeX(1.0f, 1.0f));
			break;
		
		//ZɐLтJvZ
		case BASIC_SHAPE_CAPSULE_Z:
			pRet = new btCapsuleShapeZ(btCapsuleShapeZ(1.0f, 1.0f));
			break;
		
		//YɐLт~
		case BASIC_SHAPE_CYLINDER_Y:
			pRet = new btCylinderShape(btVector3(1.0f, 1.0f, 1.0f));
			break;
		
		//XɐLт~
		case BASIC_SHAPE_CYLINDER_X:
			pRet = new btCylinderShapeX(btVector3(1.0f, 1.0f, 1.0f));
			break;
		
		//ZɐLт~
		case BASIC_SHAPE_CYLINDER_Z:
			pRet = new btCylinderShapeZ(btVector3(1.0f, 1.0f, 1.0f));
			break;

		//YɐLтR[
		case BASIC_SHAPE_CONE_Y:
			pRet = new btConeShape(1.0f, 1.0f);
			break;

		//XɐLтR[
		case BASIC_SHAPE_CONE_X:
			pRet = new btConeShapeX(1.0f, 1.0f);
			break;

		//ZɐLтR[
		case BASIC_SHAPE_CONE_Z:
			pRet = new btConeShapeZ(1.0f, 1.0f);
			break;
	}


	return pRet;
}



//̂̍쐬
//y߂lFȂzyF{VFCv, ̂̎pps, gk, ʁz
void CRigidBody::CreateRigidBody(BASIC_SHAPE shape, const btTransform &posture, const btVector3 &scal, float mass)
{
	btCollisionShape *pColShape ;
	bool isNull ;


	//{VFCv쐬
	pColShape = CreateNormalizeShape(shape);
	isNull = (NULL == pColShape);
	if( true == isNull ){
		return;
	}

	bool isDynamic ;
	btVector3 localInertia ;
	btDefaultMotionState *pMyMotionState ;

	//e\̌vZ
	localInertia = btVector3(0.0f, 0.0f, 0.0f);
	isDynamic = (0.0f != mass);
	if( true == isDynamic ){
		pColShape->calculateLocalInertia(mass, localInertia);
	}
	_inertia = localInertia;
	//[VXe[g쐬
	pMyMotionState = new btDefaultMotionState(posture);
	isNull = (NULL == pMyMotionState);
	if( true == isNull ){
		return;
	}
	//̂𐶐
	btRigidBody::btRigidBodyConstructionInfo rbInfo(mass, pMyMotionState, pColShape, localInertia) ;
	
	_pBody = new btRigidBody(rbInfo);
	isNull = (NULL == _pBody);
	if( true == isNull ){
		return;
	}
	//gkK
	_pBody->getCollisionShape( )->setLocalScaling(btVector3(scal));


	return;
}



//VFCvɂ鍄̂̍쐬
//y߂lFȂzyF{VFCvz, VFCv̍sz, VFCv̊gkz, VFCv̐,
//							̂̎pps, ̂̊gk, ʁz
void CRigidBody::CreateRigidBody(const BASIC_SHAPE *pShape, const btTransform *pTransform, const btVector3 *pScal, unsigned int shapeNum,
					 const btTransform &posture, const btVector3 &scal, float mass)
{
	btCollisionShape *pColShape ;
	btCompoundShape *pCompoundShape ;
	unsigned int i ;
	bool isNull ;


	//VFCv쐬
	pCompoundShape = new btCompoundShape;
	for( i = 0; i < shapeNum; i ++ ){
		pColShape = CreateNormalizeShape(*(pShape + i));
		isNull = (NULL == pColShape);
		if( true == isNull ){
			return;
		}
		pColShape->setLocalScaling(*(pScal + i));
		pCompoundShape->addChildShape(*(pTransform + i), pColShape);
	}

	bool isDynamic ;
	btVector3 localInertia ;
	btDefaultMotionState *pMyMotionState ;

	//e\̌vZ
	localInertia = btVector3(0.0f, 0.0f, 0.0f);
	isDynamic = (0.0f != mass);
	if( true == isDynamic ){
		pColShape->calculateLocalInertia(mass, localInertia);
	}
	_inertia = localInertia;
	//[VXe[g쐬
	pMyMotionState = new btDefaultMotionState(posture);
	isNull = (NULL == pMyMotionState);
	if( true == isNull ){
		return;
	}
	//̂𐶐
	btRigidBody::btRigidBodyConstructionInfo rbInfo(mass, pMyMotionState, pCompoundShape, localInertia) ;
	
	_pBody = new btRigidBody(rbInfo);
	isNull = (NULL == _pBody);
	if( true == isNull ){
		return;
	}
	//gkK
	_pBody->getCollisionShape( )->setLocalScaling(btVector3(scal));


	return;
}



//bV̍̂̍쐬
//y߂lFȂzyFbVf[^, ̂̎pps, gk, ʁz
void CRigidBody::CreateRigidBody(LPD3DXMESH pMesh, const btTransform &posture, const btVector3 &scal, float mass)
{
	btCollisionShape *pColShape ;
	bool isNull ;
	BYTE *pVertBuf ;
	unsigned int vertNum ;
	unsigned int vertSize ;
	WORD *pIndexBuf ;
	unsigned int indexNum ;
	unsigned int i ;
	btVector3 *pVert ;
	int *pIndex ;
	D3DXVECTOR3 bbMax, bbMin ;


	vertNum = pMesh->GetNumVertices( );
	vertSize = pMesh->GetNumBytesPerVertex( );
	pVert = new btVector3[vertNum];
	pMesh->LockVertexBuffer(D3DLOCK_READONLY, static_cast<void**>(static_cast<void*>(&pVertBuf)));
	D3DXComputeBoundingBox(static_cast<D3DXVECTOR3*>(static_cast<void*>(pVertBuf)), vertNum, vertSize, &bbMin, &bbMax);
	for( i = 0; i < vertNum; i ++ ){
		*(pVert + i) = *(btVector3*)pVertBuf;
		pVertBuf += vertSize;
	}
	pMesh->UnlockVertexBuffer( );
	indexNum = pMesh->GetNumFaces( );
	//OpXgbvOpXgƂĈ悤*3
	indexNum *= 3;
	pIndex = new int[indexNum];
	pMesh->LockIndexBuffer(D3DLOCK_READONLY, static_cast<void**>(static_cast<void*>(&pIndexBuf)));
	for( i = 0; i < indexNum; i ++ ){
		*(pIndex + i) = *(pIndexBuf + i);
	}
	pMesh->UnlockIndexBuffer( );
	indexNum /= 3;
	btStridingMeshInterface *pMeshData ;

	pMeshData = new btTriangleIndexVertexArray(indexNum, pIndex, sizeof(int) * 3, vertNum,
		static_cast<btScalar*>(static_cast<void*>(pVert)), sizeof(btVector3));
	pColShape = new btBvhTriangleMeshShape(pMeshData, true, btVector3(bbMin.x, bbMin.y, bbMin.z), btVector3(bbMax.x, bbMax.y, bbMax.z));

	bool isDynamic ;
	btVector3 localInertia ;
	btDefaultMotionState *pMyMotionState ;

	//e\̌vZ
	localInertia = btVector3(0.0f, 0.0f, 0.0f);
	isDynamic = (0.0f != mass);
	if( true == isDynamic ){
		pColShape->calculateLocalInertia(mass, localInertia);
	}
	_inertia = localInertia;
	//[VXe[g쐬
	pMyMotionState = new btDefaultMotionState(posture);
	isNull = (NULL == pMyMotionState);
	if( true == isNull ){
		return;
	}
	//̂𐶐
	btRigidBody::btRigidBodyConstructionInfo rbInfo(mass, pMyMotionState, pColShape, localInertia) ;
	
	_pBody = new btRigidBody(rbInfo);
	isNull = (NULL == _pBody);
	if( true == isNull ){
		return;
	}
	//gkK
	_pBody->getCollisionShape( )->setLocalScaling(btVector3(scal));


	return;
}



//w肵[hɍ̂o^
//y߂lFȂzyF̂o^Bullet̃[hz
void CRigidBody::AppendWorld(btDiscreteDynamicsWorld *pWorld)
{
	//[hɍ̂ǉ
	pWorld->addRigidBody(_pBody);


	return;
}



//w肵[h獄̂폜
//y߂lFȂzyF̂폜Bullet̃[hz
void CRigidBody::RemoveWorld(btDiscreteDynamicsWorld *pWorld)
{
	int i ;
	btCollisionObject *obj ;

	//̂폜
	for( i = 0; i < pWorld->getNumCollisionObjects( ); i ++ ){
		obj = pWorld->getCollisionObjectArray( )[i];
		//gȂm߂
		if( btRigidBody::upcast(obj) == _pBody ){
			pWorld->removeCollisionObject(obj);
			break;
		}
	}


	return;
}



//̂̍폜
//y߂lFȂzyFȂz
void CRigidBody::DeleteRigidBody(void)
{
	bool isNull ;


	//̂NULL̏ꍇ͉Ȃ
	isNull = (NULL == _pBody);
	if( true == isNull ){
		return;
	}

	//[VXe[g̍폜
	isNull = (NULL == _pBody->getMotionState( ));
	if( false == isNull ){
		delete _pBody->getMotionState( );
		_pBody->setMotionState(NULL);
	}
	//VFCv̍폜
	isNull = (NULL == _pBody->getCollisionShape( ));
	if( false == isNull ){
		btCollisionShape *pCollShape ;
		btCompoundShape *pCompoundShape ;

		pCollShape = _pBody->getCollisionShape( );
		pCompoundShape = dynamic_cast<btCompoundShape*>(pCollShape);
		isNull = (NULL == pCompoundShape);
		//btCompoundShape^ɃLXgłꍇ́ÃVFCv
		if( false == isNull ){
			unsigned int i ;
			unsigned int num ;

			num = pCompoundShape->getNumChildShapes( );
			for( i = 0; i < num; i ++ ){
				delete pCompoundShape->getChildShape(i);
			}
		}
		delete _pBody->getCollisionShape( );
		_pBody->setCollisionShape(NULL);
	}
	//̂폜
	delete _pBody;
	_pBody = NULL;


	return;
}



//s̐ݒ
//y߂lFȂzyFZbgBulletsz
void CRigidBody::SetTransform(const btTransform &matrix)
{
	//̂X[vԂɂȂĂ\̂ŁAANeBuɂ
	_pBody->activate( );
	//݂̍sZbg
	_pBody->getMotionState( )->setWorldTransform(matrix);
	_pBody->setCenterOfMassTransform(matrix);


	return;
}



//݂̍s擾
//y߂lFBulletszyFȂz
btTransform CRigidBody::GetTransform(void) const
{
	btTransform ret ;


	_pBody->getMotionState( )->getWorldTransform(ret);


	return ret;
}



//IuWFNgɎw֗͂
//y߂lFȂzyF, ͂_z
void CRigidBody::SetForce(const btVector3 &vec, const btVector3 &point)
{
	//̂X[vԂɂȂĂ\̂ŁAANeBuɂ
	_pBody->activate( );
	_pBody->applyForce(vec, point);


	return;
}



//IuWFNgɔCӎ̉]͂
//y߂lFȂzyF](X,Y,ZeɔCӂ̉]͂^)z
void CRigidBody::SetAngVelocity(const btVector3 &vec)
{
	//̂X[vԂɂȂĂ\̂ŁAANeBuɂ
	_pBody->activate( );
	_pBody->setAngularVelocity(vec);


	return;
}



//̂̊gk擾
//y߂lF̂̊gkzyFȂz
btVector3 CRigidBody::GetScaling(void) const
{
	return _pBody->getCollisionShape( )->getLocalScaling( );
}



//̂̃Ll}eBbNݒ肷
//y߂lFȂzyFLl}eBbNIuWFNgɂꍇtruez
void CRigidBody::SetKinematic(bool kinematic)
{
	bool isKinematic ;


	isKinematic = _pBody->isKinematicObject( );
	//݂̒lƃZbglꍇ͉Ȃ
	if( isKinematic == kinematic ){
		return;
	}
	if( true == kinematic ){
		//̂ɃLl}eBbNIuWFNgtOZbg
		_pBody->setCollisionFlags(_pBody->getCollisionFlags( ) | btCollisionObject::CF_KINEMATIC_OBJECT);
		_pBody->setActivationState(DISABLE_DEACTIVATION);
		_pBody->setMassProps(0.0f, btVector3(0.0f, 0.0f, 0.0f));
		_inertia = btVector3(0.0f, 0.0f, 0.0f);
		//e\̒lXV
		_pBody->updateInertiaTensor( );
	}
	else{
		//̂Ll}eBbNIuWFNgtO菜
		_pBody->setCollisionFlags(_pBody->getCollisionFlags( ) ^ btCollisionObject::CF_KINEMATIC_OBJECT);
		//DISABLE_DEACTIVATIONZbgꂽsetActivationStateĂł؂ւȂ߁AĂ
		_pBody->forceActivationState(ACTIVE_TAG);
		//ʂ͂Ƃ肠1ɂĂ
		_pBody->getCollisionShape( )->calculateLocalInertia(1.0f, _inertia);
		_pBody->setMassProps(1.0f, _inertia);
		//e\̒lXV
		_pBody->updateInertiaTensor( );
	}


	return;
}



//̍̂ɑ΂ăCs
//y߂lFȂzyF̍̂o^ĂBullet̃[h, C̍, C̐, C̏i[NXz
void CRigidBody::CollisionToRay(btDiscreteDynamicsWorld *pWorld, const btTransform &rayFrom, const btTransform &rayTo, CRayResult *pRayResult) const
{
	//CRayResult̏Փ˂ǂ̏Zbg
	pRayResult->m_collisionObject = NULL;
	//Cs
	pWorld->getCollisionWorld( )->rayTestSingle(rayFrom, rayTo, _pBody, _pBody->getCollisionShape( ),
		_pBody->getWorldTransform( ), *pRayResult);


	return;
}



//====================CRayResult====================
//RXgN^
//yFȂz
CRayResult::CRayResult(void):
_normal(0.0f, 0.0f, 0.0f)
{
	return;
}



//ՓˌoɌĂ΂֐̎
//y߂lF0zyFC̏񂪓\, truez
btScalar CRayResult::addSingleResult(btCollisionWorld::LocalRayResult& rayResult, bool normalInWorldSpace)
{
	//Փ˂IuWFNg擾
	m_collisionObject = rayResult.m_collisionObject;
	//@擾
	_normal = rayResult.m_hitNormalLocal;
	//C̏Փˋ䗦擾
	m_closestHitFraction = rayResult.m_hitFraction;


	return 0.0f;
}



//[JȖ@̎擾
//y߂lF@zyFȂz
const btVector3& CRayResult::GetNormal(void) const
{
	return _normal;
}

